<div class="social-bee">
    <div class="lp-container">
        <div class="hero">
            <img src="{$WEB_ROOT}/assets/img/marketconnect/socialbee/SocialBeeLogo.png" alt="SocialBee">
            <div class="content-block__text">
                <h2>
                    {lang key='store.socialbee.header'}
                </h2>
                <span class="hero__description">
                    {lang key='store.socialbee.hero'}
                </span>
            </div>
        </div>
    </div>

    <div class="planner">
        <div class="lp-container">
            <img src="{$WEB_ROOT}/assets/img/marketconnect/socialbee/planner.png" alt="planner">
        </div>
    </div>

    <div class="lp-container">
        <div class="content-block">
            <div>
                <h2>
                    {lang key='store.socialbee.content.header'}
                </h2>
                <div class="content-block__text">
                    <p>
                        {lang key='store.socialbee.content.p1'}
                    </p>
                    <p>
                        {lang key='store.socialbee.content.p2'}
                    </p>
                    <p>
                        {lang key='store.socialbee.content.p3'}
                    </p>
                    <button>{lang key='learnmore'}</button>
                </div>
            </div>
            <img src="{$WEB_ROOT}/assets/img/marketconnect/socialbee/SocialBeeFeatures.png" alt="Features">
        </div>
    </div>

    <div class="action-buttons">
        <button data-target="features_create">{lang key='create'}</button>
        <button data-target="features_schedule">{lang key='store.schedule'}</button>
        <button data-target="features_engage">{lang key='store.engage'}</button>
        <button data-target="features_collaborate">{lang key='store.collaborate'}</button>
        <button data-target="features_analyze">{lang key='store.analyze'}</button>
    </div>

    <div class="lp-container">
        <div class="features wrapper">
            <div class="features feature_block features_create">
                <div class="features__item">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/socialbee/visuals.png" alt="">
                    <p>{lang key='store.socialbee.features.create.i1'}</p>
                </div>
                <div class="features__item">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/socialbee/ai-prompts.png" alt="">
                    <p>{lang key='store.socialbee.features.create.i2'}</p>
                </div>
                <div class="features__item">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/socialbee/pencil.png" alt="">
                    <p>{lang key='store.socialbee.features.create.i3'}</p>
                </div>
                <div class="features__item">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/socialbee/copilot.png" alt="">
                    <p>{lang key='store.socialbee.features.create.i4'}</p>
                </div>
                <div class="features__item">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/socialbee/folder.png" alt="">
                    <p>{lang key='store.socialbee.features.create.i5'}</p>
                </div>
                <div class="features__item">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/socialbee/carousel.png" alt="">
                    <p>{lang key='store.socialbee.features.create.i6'}</p>
                </div>
            </div>
            <div class="features feature_block features_schedule hidden">
                <div class="features__item">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/socialbee/schedule.png" alt="">
                    <p>{lang key='store.socialbee.features.schedule.i1'}</p>
                </div>
                <div class="features__item">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/socialbee/calendar.png" alt="">
                    <p>{lang key='store.socialbee.features.schedule.i2'}</p>
                </div>
                <div class="features__item">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/socialbee/posts.png" alt="">
                    <p>{lang key='store.socialbee.features.schedule.i3'}</p>
                </div>
                <div class="features__item">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/socialbee/timer.png" alt="">
                    <p>{lang key='store.socialbee.features.schedule.i4'}</p>
                </div>
                <div class="features__item">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/socialbee/reuse.png" alt="">
                    <p>{lang key='store.socialbee.features.schedule.i5'}</p>
                </div>
                <div class="features__item">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/socialbee/edit.png" alt="">
                    <p>{lang key='store.socialbee.features.schedule.i6'}</p>
                </div>
            </div>
            <div class="features feature_block features_engage hidden">
                <div class="features__item">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/socialbee/inbox.png" alt="">
                    <p>{lang key='store.socialbee.features.engage.i1'}</p>
                </div>
                <div class="features__item">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/socialbee/chat.png" alt="">
                    <p>{lang key='store.socialbee.features.engage.i2'}</p>
                </div>
                <div class="features__item">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/socialbee/notify.png" alt="">
                    <p>{lang key='store.socialbee.features.engage.i3'}</p>
                </div>
                <div class="features__item">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/socialbee/interact.png" alt="">
                    <p>{lang key='store.socialbee.features.engage.i4'}</p>
                </div>
                <div class="features__item">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/socialbee/mention.png" alt="">
                    <p>{lang key='store.socialbee.features.engage.i5'}</p>
                </div>
                <div class="features__item">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/socialbee/comments.png" alt="">
                    <p>{lang key='store.socialbee.features.engage.i6'}</p>
                </div>
            </div>
            <div class="features feature_block features_collaborate hidden">
                <div class="features__item">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/socialbee/tag.png" alt="">
                    <p>{lang key='store.socialbee.features.collaborate.i1'}</p>
                </div>
                <div class="features__item">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/socialbee/approve.png" alt="">
                    <p>{lang key='store.socialbee.features.collaborate.i2'}</p>
                </div>
                <div class="features__item">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/socialbee/tick.png" alt="">
                    <p>{lang key='store.socialbee.features.collaborate.i3'}</p>
                </div>
                <div class="features__item">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/socialbee/duplicate.png" alt="">
                    <p>{lang key='store.socialbee.features.collaborate.i4'}</p>
                </div>
                <div class="features__item">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/socialbee/settings.png" alt="">
                    <p>{lang key='store.socialbee.features.collaborate.i5'}</p>
                </div>
                <div class="features__item">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/socialbee/clients.png" alt="">
                    <p>{lang key='store.socialbee.features.collaborate.i6'}</p>
                </div>
            </div>
            <div class="features feature_block features_analyze hidden">
                <div class="features__item">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/socialbee/statistics.png" alt="">
                    <p>{lang key='store.socialbee.features.analyze.i1'}</p>
                </div>
                <div class="features__item">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/socialbee/track.png" alt="">
                    <p>{lang key='store.socialbee.features.analyze.i2'}</p>
                </div>
                <div class="features__item">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/socialbee/comments.png" alt="">
                    <p>{lang key='store.socialbee.features.analyze.i3'}</p>
                </div>
                <div class="features__item">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/socialbee/compare.png" alt="">
                    <p>{lang key='store.socialbee.features.analyze.i4'}</p>
                </div>
                <div class="features__item">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/socialbee/filter.png" alt="">
                    <p>{lang key='store.socialbee.features.analyze.i5'}</p>
                </div>
                <div class="features__item">
                    <img src="{$WEB_ROOT}/assets/img/marketconnect/socialbee/report.png" alt="">
                    <p>{lang key='store.socialbee.features.analyze.i6'}</p>
                </div>
            </div>

            <button>{lang key='store.socialbee.packages'}</button>
        </div>

        <div class="pricing__header">
            <h2>{lang key='store.socialbee.pricing.header.title'}</h2>
            <p>
                {lang key='store.socialbee.pricing.header.body'}
            </p>
        </div>

        <div class="pricing-table-container">
            <div class="pricing-table">
                <!-- Header Row -->
                <div class="pricing-table__row pricing-table__header-row">
                    <div class="pricing-table__cell pricing-table__header-cell pricing-table__feature-header">{lang key='features'}</div>
                    {foreach $planComparisonData as $plan}
                    <div class="pricing-table__cell pricing-table__header-cell pricing-table__plan-header">
                        {lang key='store.socialbee.plan.'|cat:($plan->name|lower)}
                    </div>
                    {/foreach}
                </div>

                {foreach $planFeatures as $featureKey => $featureValues}
                    <div class="pricing-table__row">
                        <div class="pricing-table__cell pricing-table__feature-name">
                            {lang key="store.socialbee.comparison."|cat:$featureKey}
                        </div>
                        {foreach $featureValues as $featureValue}
                        <div class="pricing-table__cell">
                            {if $featureValue}
                                {if $featureValue === true}
                                    <span class="pricing-table__icon pricing-table__icon--check">✓</span>
                                {elseif is_string($featureValue)}
                                    {lang key="store.socialbee.comparison."|cat:$featureValue}
                                {else}
                                    {$featureValue}
                                {/if}
                            {else}
                                <span class="pricing-table__icon pricing-table__icon--cross">✗</span>
                            {/if}
                        </div>
                        {/foreach}
                    </div>
                {/foreach}

                <!-- Price -->
                <div class="pricing-table__row">
                    <div class="pricing-table__cell pricing-table__feature-name">
                        {lang key='store.price'}
                    </div>
                    {foreach $planComparisonData as $plan}
                        <div class="pricing-table__cell">
                            {if  $plan->isFree()}
                                {lang key="orderpaymenttermfree"}
                            {else}
                                {$plan->pricing()->first()->toPrefixedString()}
                            {/if}
                        </div>
                    {/foreach}
                </div>

                <!-- Get Started buttons -->
                <div class="pricing-table__row">
                    <div class="pricing-table__cell pricing-table__feature-name"></div>
                    {foreach $planComparisonData as $plan}
                        <div class="pricing-table__cell">
                            <form method="post" action="{routePath('cart-order')}">
                                <input type="hidden" name="checkout" value="1">
                                <input type="hidden" name="pid" value="{$plan->id}">
                                <button class="btn small-btn">{lang key='store.getstarted'}</button>
                            </form>
                        </div>
                    {/foreach}
                </div>
            </div>
        </div>

        <div class="content-block faq">
            <div>
                <h2>{lang key='store.faq'}</h2>
                <div class="content-block__text">
                    <p>{lang key='store.socialbee.faq.unanswered'}</p>
                </div>
            </div>
            <div class="accordion">
                <div class="tab">
                    <input type="checkbox" name="accordion-1" id="cb1" checked>
                    <label for="cb1" class="tab__label">
                        <span>
                            {lang key='store.socialbee.faq.q1'}
                        </span>
                    </label>
                    <div class="tab__content">
                        <p>
                            {lang key='store.socialbee.faq.a1'}
                        </p>
                    </div>
                </div>

                <div class="tab">
                    <input type="checkbox" name="accordion-2" id="cb2">
                    <label for="cb2" class="tab__label">
            <span>
                {lang key='store.socialbee.faq.q2'}
            </span>
                    </label>
                    <div class="tab__content">
                        <p>{lang key='store.socialbee.faq.a2.text'}</p>
                        <ul>
                            <li>
                                {lang key='store.socialbee.faq.a2.i1'}
                            </li>
                            <li>
                                {lang key='store.socialbee.faq.a2.i2'}
                            </li>
                            <li>
                                {lang key='store.socialbee.faq.a2.i3'}
                            </li>
                            <li>
                                {lang key='store.socialbee.faq.a2.i4'}
                            </li>
                            <li>
                                {lang key='store.socialbee.faq.a2.i5'}
                            </li>
                        </ul>
                    </div>
                </div>

                <div class="tab">
                    <input type="checkbox" name="accordion-3" id="cb3">
                    <label for="cb3" class="tab__label">
                        <span>
                          {lang key='store.socialbee.faq.q3'}
                        </span>
                    </label>
                    <div class="tab__content">
                        <p>
                            {lang key='store.socialbee.faq.a3'}
                        </p>
                    </div>
                </div>

                <div class="tab">
                    <input type="checkbox" name="accordion-4" id="cb4">
                    <label for="cb4" class="tab__label">
                        <span>
                            {lang key='store.socialbee.faq.q4'}
                        </span>
                    </label>
                    <div class="tab__content">
                        <p>
                            {lang key='store.socialbee.faq.a4.text'}
                        </p>

                        <ul>
                            <li><b>{lang key='store.socialbee.plan.pro'}:</b>
                                <ul class="faq__nested-list">
                                    <li>{lang key='store.socialbee.profiles' num=25}</li>
                                    <li>{lang key='store.socialbee.workspaceusers' num=3} | {lang key='store.socialbee.workspaceusers' num=5}</li>
                                </ul>
                            </li>

                            <li><b>{lang key='store.socialbee.plan.pro50'}:</b>
                                <ul class="faq__nested-list">
                                    <li>{lang key='store.socialbee.profiles' num=50}</li>
                                    <li>{lang key='store.socialbee.workspaceusers' num=5} | {lang key='store.socialbee.workspaceusers' num=10}</li>
                                </ul>
                            </li>

                            <li><b>{lang key='store.socialbee.plan.pro100'}:</b>
                                <ul class="faq__nested-list">
                                    <li>{lang key='store.socialbee.profiles' num=100}</li>
                                    <li>{lang key='store.socialbee.workspaceusers' num=5} | {lang key='store.socialbee.workspaceusers' num=20}</li>
                                </ul>
                            </li>

                            <li><b>{lang key='store.socialbee.plan.pro150'}:</b>
                                <ul class="faq__nested-list">
                                    <li>{lang key='store.socialbee.profiles' num=150}</li>
                                    <li>{lang key='store.socialbee.workspaceusers' num=5} | {lang key='store.socialbee.workspaceusers' num=30}</li>
                                </ul>
                            </li>
                        </ul>
                    </div>
                </div>

                <div class="tab">
                    <input type="checkbox" name="accordion-5" id="cb5">
                    <label for="cb5" class="tab__label">
                        <span>{lang key='store.socialbee.faq.q5'}</span>
                    </label>
                    <div class="tab__content">
                        <p>{lang key='store.socialbee.faq.a5'}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    :root {
        --max-width: 1248px;
        --yellow: #f3c500;
    }

    section#main-body {
        padding: 0;
    }

    .social-bee h2, .social-bee p, .social-bee span {
        line-height: 1.5;
    }

    .social-bee ul {
        line-height: 2;
        list-style-position: outside;
    }

    .social-bee button {
        cursor: pointer;
        transition: all 0.35s;
        box-shadow: none !important;
        outline: none !important;
        &:hover {
            opacity: 0.75;
        }
    }

    .social-bee {
        background: #fff;
    }

    .social-bee .lp-container {
        margin: 0 auto;
        display: flex;
        flex-direction: column;
        align-items: center;
        gap: 90px;
    }

    .social-bee .hero {
        max-width: var(--max-width);
        display: flex;
        flex-direction: column;
        align-items: center;
        gap: 24px;
        margin-top: 90px;
        margin-bottom: 78px;
        color: #212533;

        & .content-block__text {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 32px;
        }

        & h2 {
            font-size: 40px;
            font-weight: 700;
            text-align: center;
            width: 772px;
        }

        & .hero__description {
            font-size: 18px;
            text-align: center;
            max-width: 512px;
        }

        & img {
            display: block;
            max-width: 100%;
        }
    }

    .social-bee .planner {
        width: 100%;
        min-height: 470px;
        margin-top: 60px;
        margin-bottom: 90px;
        padding-bottom: 32px;
        background-color: #212533;
        display: flex;
        justify-content: center;
        & img {
            display: block;
            margin-top: -140px;
            height: auto;
        }
    }

    .social-bee .content-block {
        max-width: var(--max-width);
        padding: 0 24px;
        display: flex;
        align-items: center;
        gap: 24px;

        & img {
            display: block;
            height: fit-content;
            max-width: 60%;
        }

        & h2 {
            font-weight: 700;
            font-size: 32px;
            margin-bottom: 50px;
            position: relative;
            padding-top: 20px;
            color: #333333;

            &::before {
                content: "";
                position: absolute;
                top: 0;
                left: 0;
                width: 186px;
                height: 8px;
                background-color: var(--yellow);
            }
        }

        & .content-block__text {
            max-width: 400px;

            & p {
                margin-bottom: 36px;
                line-height: 2;
            }

            & button {
                background-color: var(--yellow);
                padding: 16px 56px;
                border: none;
                border-radius: 50px;
                font-size: 18px;
                font-weight: 600;
            }
        }
    }

    .social-bee .content-block.faq {
        padding-bottom: 120px;
        align-items: start;
        padding-top: 90px;
        border-top: 1px solid #ededed;

        & > div:first-child {
            flex-basis: 60%;
        }
    }

    .social-bee .action-buttons {
        height: 140px;
        margin-top: 90px;
        margin-bottom: 90px;
        background-color: #f5f5f5;
        width: 100%;
        display: flex;
        gap: 32px;
        justify-content: center;
        align-items: center;

        & button {
            font-size: 14px;
            border-radius: 50px;
            border: 2px solid transparent;
            padding: 12px 32px;
            max-height: fit-content;
            background-color: transparent;
        }

        & .active {
            background-color: #fff;
            border: 2px solid #e1e1e1;
        }
    }

    .social-bee .features.wrapper {
        max-width: var(--max-width);
        margin: 0 auto;
        padding: 0px 16px 88px;
        border-bottom: 1px solid #ededed;
        display: flex;
        flex-direction: column;
        align-items: center;

        & button {
            background-color: var(--yellow);
            padding: 16px 56px;
            border: none;
            border-radius: 50px;
            font-size: 18px;
            font-weight: 600;
        }
    }

    .social-bee .features {
        display: flex;
        row-gap: 90px;
        column-gap: 24px;
        justify-content: center;
        flex-wrap: wrap;

        & .features__item {
            max-width: 380px;
            text-align: center;

            & img {
                height: 188px;
                width: 188px;
            }

            & p {
                margin-top: 48px;
                line-height: 2;
            }
        }
    }

    .social-bee .pricing__header {
        max-width: 540px;
        margin: 0 auto -24px auto;
        display: flex;
        flex-direction: column;
        align-items: center;
        text-align: center;

        & h2 {
            font-size: 40px;
            font-weight: 800;
            max-width: 540px;
            color: #212533;
        }

        p {
            margin-top: 32px;
            font-size: 18px;
        }
    }

    @media (max-width: 1280px) {
        .social-bee .content-block {
            flex-direction: column;
            align-items: center;

            & img {
                max-width: 100%;
            }

            & .content-block__text {
                max-width: 100%;
            }
        }

        .social-bee .content-block.faq {
            align-items: start;
            gap: 0;
        }

        .social-bee .pricing-table {
            width: auto;
            min-width: 1024px;
        }
    }

    /* Media queries */

    @media (max-width: 1024px) {
        .social-bee .hero {
            padding: 0 24px;
        }

        .social-bee .pricing__header {
            padding: 0 24px;
        }

        .social-bee .pricing-table {
            margin: 0 24px;
        }

        .social-bee .planner {
            min-height: auto;

            & img {
                display: block;
                max-width: 100%;
                height: fit-content;
            }
        }

        .social-bee .action-buttons {
            gap: 16px;
        }
    }

    @media (max-width: 768px) {
        .social-bee .action-buttons {
            gap: 0;
            flex-wrap: wrap;
        }

        .social-bee .tab {
            max-height: fit-content;
        }

        .social-bee .tab input:checked ~ .tab__content {
            padding: 16px;
        }

        .social-bee .features .features__item p {
            margin-top: 24px;
        }
    }

    /* Accordion styles */

    .social-bee .faq {
        padding-bottom: 90px;
    }

    .social-bee .tab {
        position: relative;
        max-height: 48px;
        margin-bottom: 12px;
    }
    .social-bee .tab:has(input:checked) {
        max-height: fit-content;
    }
    .social-bee .tab input {
        position: absolute;
        opacity: 0;
        z-index: -1;
    }
    .social-bee .tab__content {
        max-height: 0;
        overflow: hidden;
    }
    .social-bee .tab input:checked ~ .tab__content {
        max-height: fit-content;
        padding: 16px 32px;
    }

    /* Visual styles */

    .social-bee .accordion {
        overflow: hidden;
    }
    .social-bee .tab__label,
    .social-bee .tab__close {
        display: flex;
        background: var(--yellow);
        cursor: pointer;
    }
    .social-bee .tab__label {
        justify-content: space-between;
        padding: 0.8rem 1rem;

        & span {
            line-height: 1.5;
        }
    }
    .social-bee .tab__label::after {
        content: "\276F";
        width: 1em;
        height: 1em;
        margin-left: 10px;
        text-align: center;
        transform: rotate(90deg);
        transition: all 0.35s;
    }
    .social-bee .tab input:checked + .tab__label::after {
        transform: rotate(270deg);
    }
    .social-bee .tab__content ul {
        list-style: inside;

        & .faq__nested-list {
            padding-left: 32px;
            list-style: circle;
        }
    }
    .social-bee .tab__close {
        justify-content: flex-end;
        padding: 0.5rem 1rem;
        font-size: 0.75rem;
    }

    /* Table styles */

    .social-bee .pricing-table-container {
        width: 100%;
        max-width: 100%;
        overflow-x: auto;
        max-height: none;
    }

    .hidden {
        display: none !important;
    }

    .social-bee .pricing-table {
        width: var(--max-width);
        min-width: 1024px;
        margin: 0 auto;
    }

    .social-bee .pricing-table__header-row {
        background-color: #f5f5f5;

        &.pricing-table__row:hover {
            background-color: #f5f5f5;
        }
    }

    .social-bee .pricing-table__row {
        display: flex;
        width: 100%;

        &:hover {
            background-color: #fdf9eb;
        }
    }

    .social-bee .pricing-table__cell {
        padding: 6px 12px;
        flex: 1;
        display: flex;
        align-items: center;
        justify-content: center;
        text-align: center;
        line-height: 1.5;
        font-size: 14px;
    }

    .social-bee .pricing-table__header-cell {
        font-weight: bold;
        padding: 24px 15px;
    }

    .social-bee .pricing-table__feature-name {
        flex: 1.5;
        justify-content: flex-start;
        text-align: left;
        font-weight: normal;
    }

    .social-bee .pricing-table__feature-header {
        background-color: var(--yellow);
        color: #333;
        flex: 1.5;
    }

    .social-bee .pricing-table__icon.pricing-table__icon--check {
        color: green;
        font-weight: bold;
    }

    .social-bee .pricing-table__icon.pricing-table__icon--cross {
        color: red;
        font-weight: bold;
    }

    .social-bee .btn {
        background-color: var(--yellow);
        color: #333;
        padding: 10px 15px;
        border: none;
        border-radius: 20px;
        cursor: pointer;
        font-weight: bold;
        width: 100%;
        max-width: 120px;
        margin: 10px auto;
    }

    .social-bee .btn.small-btn {
        font-weight: normal;
        font-size: 14px;
        padding: 8px 12px;
    }

    .social-bee ~ p {
        padding-top: 16px;
    }
</style>

<script>
    const learnMoreBtn = document.querySelector('.content-block button');
    const viewPricingBtn = document.querySelector('.features button');

    const pricingTable = document.querySelector('.pricing-table-container');

    function scrollToElement(element) {
        const rect = element.getBoundingClientRect();

        const scrollTop = window.pageYOffset + rect.top - 16;

        window.scrollTo({
            top: scrollTop,
            behavior: 'smooth'
        });
    }

    if (learnMoreBtn) {
        learnMoreBtn.addEventListener('click', () => {
            scrollToElement(pricingTable);
        });
    }

    if (viewPricingBtn) {
        viewPricingBtn.addEventListener('click', () => {
            scrollToElement(pricingTable);
        });
    }

    const buttons = document.querySelectorAll('.action-buttons button');
    const items = document.querySelectorAll('.feature_block');

    function updateContent(target) {
        const items = document.querySelectorAll('.feature_block');
        items.forEach(function(item) {
            if (!item.classList.contains('hidden')) {
                item.classList.add('hidden');
            }
        });

        const targetElement = document.querySelector('.' + target);
        if (targetElement) {
            targetElement.classList.remove('hidden');
        }
    }

    buttons.forEach(button => {
        button.addEventListener('click', function() {
            buttons.forEach(btn => btn.classList.remove('active'));
            this.classList.add('active');

            const target = this.getAttribute('data-target');
            updateContent(target);
        });
    });

    document.addEventListener('DOMContentLoaded', function() {
        buttons[0].classList.add('active');
        const initialTarget = buttons[0].getAttribute('data-target');
        updateContent(initialTarget);
    });
</script>